/*******************************************************
Filename		:  di_subject_taxon.sql
Release 		:  2.0
SIR			:  
Description		:  Creates the dimension table DI_SUBJECT_TAXON and related objects.
Author			:  Thieu Nguyen
Date			:  7/15/2003
			   08/04/2003 using both pk_isn, activity_subject_taxon for primary key to eliminate duplicated
			   01/16/04 - SIR 1586 Moved connect string to master install script -JW
Comments		:  
**********************************************************/

spool di_subject_taxon.log

drop sequence seq_subject_taxon;

create sequence seq_subject_taxon
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_subject_taxon;
create table di_subject_taxon
(PK_ISN number(12) not null,
 ACTIVITY_SUBJECT_TAXON varchar2(69) not null)
tablespace storetdata
storage (initial 256K next 256K)
nologging;


--Create primary key
alter table di_subject_taxon
add constraint pk_subject_taxon primary key (pk_isn)
using index
tablespace storetindx
storage (initial 128k next 128k);

--add data to di_subject_taxon
set serveroutput on
declare
cursor c1 is SELECT distinct ACTIVITY_SUBJECT_TAXON 
FROM fa_biological_result
where ACTIVITY_SUBJECT_TAXON  is not null;	

begin
for c1_var in c1 loop
insert into di_subject_taxon(PK_ISN,ACTIVITY_SUBJECT_TAXON)
values(seq_subject_taxon.nextval,c1_var.ACTIVITY_SUBJECT_TAXON);
end loop;
commit;
end;
/

--update fks in FA_BIOLOGICAL_RESULT
declare
cursor c1 is select * from di_subject_taxon;

begin
for c1_var in c1 loop
update FA_BIOLOGICAL_RESULT
set FK_SUBJECT_TAXON = c1_var.pk_isn
where ACTIVITY_SUBJECT_TAXON = c1_var.ACTIVITY_SUBJECT_TAXON;
end loop;
commit;
end;
/
spool off;
